/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.ScannerTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScannerTrapDoorBlock
extends BaseIronTrapDoorBlock
implements IOverlayDisplay,
IDisguisable {
    public ScannerTrapDoorBlock(Material material) {
        super(material);
        this.func_149722_s();
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor) {
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)field_176283_b, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new ScannerTrapdoorBlockEntity();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(actualState, world, pos, entity);
        }
        return this.field_149762_H;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            if (!((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
                actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
            }
        } else {
            ScannerTrapDoorBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return IDisguisable.getDisguisedBlockFaceShape(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return IDisguisable.shouldDisguisedSideBeRendered(state, world, pos, side);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world.func_175625_s(pos));
        return disguisedState != null ? disguisedState : state;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (IDisguisable.shouldPickBlockDisguise((IBlockAccess)world, pos, player)) {
            return this.getDisguisedStack((IBlockAccess)world, pos);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

